package com.example.sefinsa_app;

import static com.example.sefinsa_app.ui.avales.AvalesFragment.avales;
import static com.example.sefinsa_app.ui.avales.AvalesFragment.avalesAdapter;
import static com.example.sefinsa_app.ui.clientes.ClientesFragment.clientes;
import static com.example.sefinsa_app.ui.clientes.ClientesFragment.clientesAdapter;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.VolleyS;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class NetworkChangeReceiver extends BroadcastReceiver {
    private final NetworkChangeListener listener;
    private static Context appContext;
    public NetworkChangeReceiver(NetworkChangeListener listener) {
        this.listener = listener;
    }
    private boolean isProcessing = false;
    @Override
    public void onReceive(Context context, Intent intent) {
        appContext = context.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        listener.onNetworkChanged(isConnected);
        //Log.d("SQLite", "Dato de conexion. se recibio informacion de onReceive...........");
        if (isConnected) {
            // Procesar la cola de solicitudes
            //Log.d("SQLite", "Dato de conexion. Se recupero la conexion...........");
            procesarColaSolicitudes();
        }
    }

    public interface NetworkChangeListener {
        void onNetworkChanged(boolean isConnected);
    }

    private void procesarColaSolicitudes() {
        //Log.d("SQLite", "Entrando a procesarColaSolicitudes...");
        ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();

        if (colaSolicitudes.estaVacia()) {
            //Log.d("SQLite", "La cola está vacía, no se procesará ninguna solicitud.");
            isProcessing = false; // Asegurarse de liberar el estado
            return;
        }

        if (isProcessing) {
            //Log.d("SQLite", "Ya se está procesando una solicitud. Esperando a que termine...");
            return; // Prevenir múltiples procesos simultáneos
        }

        isProcessing = true; // Marcar como procesando
        SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud(); // Obtener la primera solicitud

        if (solicitud == null) {
            //Log.d("SQLite", "No se encontró una solicitud válida en la cola.");
            isProcessing = false;
            procesarColaSolicitudes(); // Continuar con el siguiente si existiera
            return;
        }

        // Procesar en función del tipo de solicitud
        switch (solicitud.getTipo()) {
            case "aval":
                //Log.d("SQLite", "Subiendo fotos de Aval...");
                subirFotosAv(solicitud.getArchivos(), solicitud.getFunc(), solicitud.getId(),
                        solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo());
                break;

            case "cliente":
                //Log.d("SQLite", "Subiendo fotos de Cliente...");
                subirFotosCl(solicitud.getArchivos(), solicitud.getFunc(), solicitud.getId(),
                        solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo());
                break;

            case "InsertAval":
                //Log.d("SQLite", "Registrando nuevo Aval...");
                registrarAvalNuevo(solicitud, colaSolicitudes, solicitud.getArchivos(),
                        solicitud.getNombreQ(), solicitud.getDireccionQ(), solicitud.getTelefonoQ(),
                        solicitud.getOtrasReferenciasQ(), solicitud.getGarantiasQ(),
                        solicitud.getRutaIdQ(), solicitud.getPoblacionIdQ(), solicitud.getColocadoraIdQ(),
                        solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo(),
                        solicitud.getClienteIDQ());
                break;

            case "InsertCliente":
                //Log.d("SQLite", "Registrando nuevo Cliente...");
                registrarClienteNuevo(solicitud, colaSolicitudes, solicitud.getArchivos(),
                        solicitud.getNombreQ(), solicitud.getDireccionQ(), solicitud.getTelefonoQ(),
                        solicitud.getOtrasReferenciasQ(), solicitud.getGarantiasQ(),
                        solicitud.getRutaIdQ(), solicitud.getPoblacionIdQ(), solicitud.getColocadoraIdQ(),
                        solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo(), solicitud.getAval_idQ());
                break;

            default:
                //Log.e("SQLite", "Tipo de solicitud desconocido: " + solicitud.getTipo());
                //colaSolicitudes.obtenerIndexSolicitudyBorrar(); // Eliminar solicitud inválida
                //isProcessing = false;  // Liberar el estado
                procesarColaSolicitudes(); // Continuar procesando la cola
                break;
        }
    }

    private void registrarAvalNuevo(SolicitudSubida solicitud, ColaSolicitudes colaSolicitudes, List<MultipartBody.Part> archivosGeneral, String nombreQ, String direccionQ, String telefonoQ,
                                    String otrasReferenciasQ, String garantiasQ, String rutaIdQ, String poblacionIdQ,
                                    String colocadoraIdQ, String cantidad_archivos_garantias_cliente2, String cantidad_archivos_cliente2, String clienteIDQ) {
        //Log.d("ArchivosJson", "Entro en funcion registrarAvalNuevo().................. ");
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "createAPP");
        RequestBody nombre_aval = RequestBody.create(MediaType.parse("multipart/form-data"), nombreQ);
        RequestBody direccion_aval = RequestBody.create(MediaType.parse("multipart/form-data"), direccionQ);
        RequestBody telefono_aval = RequestBody.create(MediaType.parse("multipart/form-data"), telefonoQ);
        RequestBody rutaId = RequestBody.create(MediaType.parse("multipart/form-data"), rutaIdQ);
        RequestBody poblacionId = RequestBody.create(MediaType.parse("multipart/form-data"), poblacionIdQ);
        RequestBody colocadoraId = RequestBody.create(MediaType.parse("multipart/form-data"), colocadoraIdQ);

        RequestBody or_aval = RequestBody.create(MediaType.parse("multipart/form-data"), otrasReferenciasQ);
        RequestBody garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), garantiasQ);

        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_cliente2);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_garantias_cliente2);


        RequestBody latitud = RequestBody.create(MediaType.parse("multipart/form-data"), "0");
        RequestBody longitud = RequestBody.create(MediaType.parse("multipart/form-data"), "0");

        Call<ResponseMe> call = retrofitInterface.registrarAval(archivosGeneral, func, nombre_aval, direccion_aval, telefono_aval,
                rutaId, poblacionId, colocadoraId, or_aval, garantias_aval, cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud);

        call.enqueue(new Callback<ResponseMe>() {
            @Override
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    // Obtener el cliente ID de la respuesta
                    if (response.body() != null && response.body().getStatus().equals("success")) {
                        String clienteId = response.body().getClienteId(); // Asegúrate de que este método exista en ResponseMe
                        //Log.d("response", "Aval registrado con ID: " + clienteId);
                        //Log.d("SQLite", "ENTRO EN SUBIDA success()...................");
// Borra la solicitud de la cola solo si la subida fue exitosa
                        ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                        SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud(); // Obtén la primera solicitud
                        if (solicitud != null) {
                            colaSolicitudes.obtenerIndexSolicitudyBorrar(); // Elimina la solicitud de la cola
                            isProcessing = false;  // Marcar como no procesando
                            procesarColaSolicitudes();
                            //Log.d("SQLite", "Solicitud eliminada de la cola tras subida exitosa");
                        }
                        // Obtener el ID antiguo de SQLite usando el nombre del aval
                        String idAntiguo = obtenerIdAntiguoDeSQLiteAval(nombreQ);
                        if (idAntiguo != null) {
                            //Log.d("SQLite", "ID antiguo obtenido de SQLite: " + idAntiguo);
                            // Actualizar registro en SQLite
                            actualizarRegistroSQLiteAval(clienteId, nombreQ, idAntiguo, clienteIDQ);
                        } else {
                            //Log.d("SQLite", "No se encontró un ID antiguo para el nombre: " + nombreQ);
                        }
                    } else {
                        //Log.d("ErrorResponse", "Error en la subida Aval: " + response.body().getMessage());
                        isProcessing = false;  // Marcar como no procesando
                        procesarColaSolicitudes();
                    }
                } else {
                    //Log.d("ErrorResponse", "Error en la subida dentro de success Aval: " + response.message());
                    ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                    SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud(); // Obtén la primera solicitud
                    if (solicitud != null) {
                        colaSolicitudes.obtenerIndexSolicitudyBorrar(); // Elimina la solicitud de la cola
                        isProcessing = false;  // Marcar como no procesando
                        procesarColaSolicitudes();
                        //Log.d("SQLite", "Solicitud eliminada de la cola tras error");
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                Log.d("SQLite", "ENTRO EN ERROR INSERT SUBIDA........................" + t.getLocalizedMessage());
                isProcessing = false;  // Marcar como no procesando
                procesarColaSolicitudes();
            }
        });
    }

    private void registrarClienteNuevo(SolicitudSubida solicitud, ColaSolicitudes colaSolicitudes, List<MultipartBody.Part> archivosGeneral, String nombreQ, String direccionQ, String telefonoQ,
                                       String otrasReferenciasQ, String garantiasQ, String rutaIdQ, String poblacionIdQ,
                                       String colocadoraIdQ, String cantidad_archivos_garantias_cliente2, String cantidad_archivos_cliente2, String avalIdQ) {
        //Log.d("ArchivosJson", "Entro en funcion registrarClienteNuevo()..................");
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();


        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "createNuevoClienteSinAval");
        RequestBody nombre_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), nombreQ);
        RequestBody direccion_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), direccionQ);
        RequestBody telefono_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), telefonoQ);
        RequestBody or_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), otrasReferenciasQ);
        RequestBody garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), garantiasQ);
        RequestBody rutaId = RequestBody.create(MediaType.parse("multipart/form-data"), rutaIdQ);
        RequestBody poblacionId = RequestBody.create(MediaType.parse("multipart/form-data"), poblacionIdQ);
        RequestBody colocadoraId = RequestBody.create(MediaType.parse("multipart/form-data"), colocadoraIdQ);
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_garantias_cliente2);
        RequestBody cantidad_archivos_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_cliente2);

        RequestBody lat = RequestBody.create(MediaType.parse("multipart/form-data"), "0");
        RequestBody lon = RequestBody.create(MediaType.parse("multipart/form-data"), "0");

        String aval_finalId="";
        if (!avalIdQ.isEmpty())
        {
            aval_finalId=avalIdQ;
        }
        //Log.d("ArchivosJson", "Entro en funcion registrarClienteNuevo().................. avalIdQ: " + avalIdQ + "/ aval_finalId: " + aval_finalId);
        RequestBody aval_final = RequestBody.create(MediaType.parse("multipart/form-data"), aval_finalId);

        Call<ResponseMe> call = retrofitInterface.registrarClienteSolo(archivosGeneral, func, nombre_cliente, direccion_cliente, telefono_cliente,
                or_cliente, garantias_cliente, rutaId, poblacionId, colocadoraId, cantidad_archivos_garantias_cliente, cantidad_archivos_cliente, lat, lon,aval_final);

        call.enqueue(new Callback<ResponseMe>() {
            @Override
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    if (response.body() != null && response.body().getStatus().equals("success")) {
                        String clienteId = response.body().getClienteId(); // Asegúrate de que este método exista en ResponseMe
                        //Log.d("response", "Cliente registrado con ID: " + clienteId);
                        //Log.d("SQLite", "ENTRO EN SUBIDA success()...................");
// Borra la solicitud de la cola solo si la subida fue exitosa
                        ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                        SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud(); // Obtén la primera solicitud
                        if (solicitud != null) {
                            colaSolicitudes.obtenerIndexSolicitudyBorrar(); // Elimina la solicitud de la cola
                            isProcessing = false;  // Marcar como no procesando
                            procesarColaSolicitudes();
                            //Log.d("SQLite", "Solicitud eliminada de la cola tras subida exitosa");
                        }
                        // Obtener el ID antiguo de SQLite usando el nombreQ
                        String idAntiguo = obtenerIdAntiguoDeSQLite(nombreQ);
                        if (idAntiguo != null) {
                            //Log.d("SQLite", "ID antiguo obtenido de SQLite: " + idAntiguo);
                            // Actualizar registro en SQLite pasando el ID antiguo y el nuevo ID
                            actualizarRegistroSQLite(clienteId, nombreQ, idAntiguo);
                        } else {
                            //Log.d("SQLite", "No se encontró un ID antiguo para el nombre: " + nombreQ);
                        }
                    } else {
                        //Log.d("ErrorResponse", "Error en la subida Cliente: " + response.body().getMessage());
                        isProcessing = false;  // Marcar como no procesando
                        procesarColaSolicitudes();
                    }
                } else {
                    //Log.d("ErrorResponse", "Error en la subida Cliente: " + response.message());
                    isProcessing = false;  // Marcar como no procesando
                    procesarColaSolicitudes();
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                Log.d("SQLite", "ENTRO EN ERROR INSERT SUBIDA........................" + t.getLocalizedMessage());
                isProcessing = false;  // Marcar como no procesando
                procesarColaSolicitudes();
            }
        });
    }

    private String obtenerIdAntiguoDeSQLite(String nombre) {
        String idAntiguo = null;
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        Cursor cursor = db.rawQuery("SELECT id FROM clientes WHERE nombre_completo = ?", new String[]{nombre});
        if (cursor.moveToFirst()) {
            idAntiguo = cursor.getString(0);
        }
        cursor.close();
        db.close();

        return idAntiguo;
    }

    private String obtenerIdAntiguoDeSQLiteAval(String nombre) {
        String idAntiguo = null;
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        Cursor cursor = db.rawQuery("SELECT id FROM avales WHERE nombre_completo = ?", new String[]{nombre});
        if (cursor.moveToFirst()) {
            idAntiguo = cursor.getString(0);
        }
        cursor.close();
        db.close();

        return idAntiguo;
    }

    // Método para actualizar el registro en SQLite
    @SuppressLint("NotifyDataSetChanged")
    private void actualizarRegistroSQLiteAval(String nuevoId, String nombre, String idAntiguo, String clienteIDQ) {
        //Log.d("SQLite", "ENTRO EN SUBIDA actualizar id y prestamo aval_id Antiguo...................");
        //Log.d("SQLite", "nuevoId aval en SQLite.............." + nuevoId);
        //Log.d("SQLite", "nombre aval en SQLite.................." + nombre);
        //Log.d("SQLite", "clienteIDQ aval en SQLite................." + clienteIDQ);

        // Abre la base de datos y actualiza el aval
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        try {
            // Crear ContentValues con el nuevo ID del aval
            ContentValues valores = new ContentValues();
            valores.put("id", nuevoId);
            valores.put("updated_at", System.currentTimeMillis()); // Fecha de actualización

            // Actualizar el registro en la tabla avales
            long resultadoAval = db.update("avales", valores, "id=?", new String[]{idAntiguo});

            if (resultadoAval == -1) {
                Log.d("SQLite", "Error al actualizar el aval en SQLite.");
            } else {
                Log.d("SQLite", "Aval actualizado con éxito en SQLite con nuevo ID: " + nuevoId);

                if (avales != null && !avales.isEmpty()) {
                    Log.d("SQLite", "La lista de avales tiene " + avales.size() + " elementos.");
                    for (Aval aval : avales) {
                        Log.d("SQLite", "ID actual en la lista: " + aval.getId());
                        if (aval.getId().equals(idAntiguo)) {
                            aval.setId(nuevoId); // Actualiza el objeto en la lista con el nuevo ID
                            Log.d("SQLite", "ID del aval actualizado a: " + nuevoId);
                            break;
                        }
                    }
                    new Handler(Looper.getMainLooper()).post(() -> {
                        avalesAdapter.notifyDataSetChanged(); // Notificar que los datos han cambiado
                    });
                } else {
                    Log.d("SQLite", "La lista de avales es null o está vacía.");
                }

            }

            // Verificar si clienteIDQ no es nulo ni vacío
            if (clienteIDQ != null && !clienteIDQ.isEmpty()) {
                // Actualizar el aval_id en la tabla de prestamos
                ContentValues valoresPrestamo = new ContentValues();
                valoresPrestamo.put("aval_id", nuevoId); // Nuevo ID del aval

                // Actualizar los préstamos donde aval_id = idAntiguo
                int resultadoPrestamos = db.update("prestamos", valoresPrestamo, "cliente_id=? AND status=0", new String[]{clienteIDQ});
                if (resultadoPrestamos > 0) {
                    Log.d("SQLite", "Se actualizaron " + resultadoPrestamos + " préstamos con el nuevo ID del aval: " + nuevoId);
                } else {
                    Log.d("SQLite", "No se encontraron préstamos con el ID del aval antiguo: " + idAntiguo);
                }

                // Actualizar el aval_id en la tabla clientes
                ContentValues valoresCliente = new ContentValues();
                valoresCliente.put("aval_id", nuevoId); // Nuevo ID del aval

                // Actualizar el cliente con el nuevo aval_id
                int resultadoCliente = db.update("clientes", valoresCliente, "id=?", new String[]{clienteIDQ});
                if (resultadoCliente > 0) {
                    Log.d("SQLite", "El aval_id se actualizó con éxito en la tabla clientes.");
                } else {
                    Log.d("SQLite", "No se encontró un cliente con el id: " + clienteIDQ);
                }

                // Llamar a CambiarAval si se actualiza el cliente
                CambiarAval(clienteIDQ, nuevoId);
            } else {
                Log.d("SQLite", "clienteIDQ es nulo o vacío. No se actualizó ni en prestamos ni en clientes.");
            }
        } catch (Exception e) {
            Log.e("SQLite", "Error al actualizar el aval y los préstamos en SQLite: " + e.getMessage(), e);
        } finally {
            db.close(); // Cierra la conexión a la base de datos
        }
    }
    private void CambiarAval(String cliente_id, String aval_id) {
        Log.d("DEBUG", "Cambiando el aval_id EN PRESTAMO.................................. " + aval_id);
        VolleyS vs = VolleyS.getInstance(appContext);
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", "CambiarAvalPrestamoClienteAaval");
            data.put("cliente_id", cliente_id);
            data.put("aval_id", aval_id);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d("DEBUG", "El aval_id DESPUES de guardar es: " + aval_id);
        Log.d("DEBUG", "El cliente_id DESPUES de guardar es: " + cliente_id);
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        Log.d("DEBUG", "El aval_id A SIDO CAMBIANDO CON EXITO EN PRESTAMO.................................. ");
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, appContext);
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    // Método para actualizar el registro en SQLite
    @SuppressLint("NotifyDataSetChanged")
    private void actualizarRegistroSQLite(String clienteId, String nombre, String idAntiguo) {
        Log.d("SQLite", "ENTRO EN SUBIDA actualizarRegistroSQLite()...................");
        Log.d("SQLite", "ENTRO EN SUBIDA actualizarRegistroSQLite() idAntiguo:..................." + idAntiguo);
        // Abre la base de datos y actualiza el cliente
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Crear ContentValues con el clienteId obtenido del servidor
        ContentValues valores = new ContentValues();
        valores.put("id", clienteId); // Actualiza el ID del cliente
        valores.put("nombre_completo", nombre);
        valores.put("updated_at", System.currentTimeMillis()); // Fecha de actualización

        // Actualizar la tabla de clientes
        long resultado = db.update("clientes", valores, "nombre_completo=?", new String[]{nombre});

        if (resultado == -1) {
            Log.d("SQLite", "Error al actualizar el cliente en SQLite NETWORKreceiver.");
        } else {
            Log.d("SQLite", "Cliente actualizado con éxito NETWORKreceiver en SQLite con ID: " + clienteId);

            // Actualizar el ID del cliente en la tabla de préstamos si aplica
            ContentValues valoresPrestamo = new ContentValues();
            valoresPrestamo.put("cliente_id", clienteId);

            int prestamosActualizados = db.update("prestamos", valoresPrestamo, "cliente_id=?", new String[]{idAntiguo});
            if (prestamosActualizados > 0) {
                Log.d("SQLite", "Se actualizaron " + prestamosActualizados + " préstamos con el nuevo cliente ID: " + clienteId);
            } else {
                Log.d("SQLite", "No se encontraron préstamos para actualizar con el cliente ID antiguo.");
            }

            // Actualizar en la lista de clientes en memoria
            for (Cliente cliente : clientes) {
                if (cliente.getNombre_completo().equals(nombre)) {
                    cliente.setId(clienteId);
                    break;
                }
            }
            new Handler(Looper.getMainLooper()).post(() -> {
                clientesAdapter.notifyDataSetChanged();
            });
        }

        db.close(); // Cierra la conexión a la base de datos
    }

    public void subirFotosAv(List<MultipartBody.Part> archivosGeneral, String func2, String aval_id2,
                           String cantidad_archivos_garantias_aval2, String cantidad_archivos_aval2) {

        Log.d("ArchivosJson", "Entro en funcion Solicitud subir fotos en subirFotosAv().................. ");
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        // Crear RequestBody para los parámetros de entrada
        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), func2);
        RequestBody aval_id = RequestBody.create(MediaType.parse("multipart/form-data"), aval_id2);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_garantias_aval2);
        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_aval2);

        if (archivosGeneral == null || archivosGeneral.isEmpty()) {
            //Log.e("ArchivosGeneralError", "La lista de archivosGeneral es nula o está vacía");
            return;
        }

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        // Llamar a la API para subir las fotos
        Call<ResponseMe> call = retrofitInterface.subirFotosA(archivosGeneral, func, aval_id, cantidad_archivos_garantias_aval, cantidad_archivos_aval);

        call.enqueue(new Callback<ResponseMe>() {
            @Override
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    //Log.d("response", "subirFotos al recuperar conexion SUCCESS.............." + response.body().getMessage());
                    // Borra la solicitud de la cola solo si la subida fue exitosa
                    ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                    SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud(); // Obtén la primera solicitud
                    if (solicitud != null) {
                        colaSolicitudes.obtenerIndexSolicitudyBorrar(); // Elimina la solicitud de la cola
                        isProcessing = false;  // Marcar como no procesando
                        procesarColaSolicitudes();
                        Log.d("SQLite", "Solicitud eliminada de la cola tras subida exitosa");
                    }
                } else {
                    isProcessing = false;  // Marcar como no procesando
                    procesarColaSolicitudes();
                    Log.d("ErrorResponse", "Error en la subida: " + response.message());
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                isProcessing = false;  // Marcar como no procesando
                procesarColaSolicitudes();
                // Aquí puedes optar por guardar el estado de la subida fallida
            }
        });
    }

    public void subirFotosCl(List<MultipartBody.Part> archivosGeneral, String func2, String cliente_id2,
                             String cantidad_archivos_garantias_cliente2, String cantidad_archivos_cliente2) {

        Log.d("ArchivosJson", "Entro en funcion Solicitud subir fotos en subirFotosCl().................. " + cliente_id2);
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        // Crear RequestBody para los parámetros de entrada
        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), func2);
        RequestBody cliente_id = RequestBody.create(MediaType.parse("multipart/form-data"), cliente_id2);
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_garantias_cliente2);
        RequestBody cantidad_archivos_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), cantidad_archivos_cliente2);

        if (archivosGeneral == null || archivosGeneral.isEmpty()) {
            //Log.e("ArchivosGeneralError", "La lista de archivosGeneral es nula o está vacía");
            return;
        }

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        // Llamar a la API para subir las fotos
        Call<ResponseMe> call = retrofitInterface.subirFotosCA(archivosGeneral, func, cliente_id, cantidad_archivos_garantias_cliente, cantidad_archivos_cliente);

        call.enqueue(new Callback<ResponseMe>() {
            @Override
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    Log.d("response", "subirFotos al recuperar conexion SUCCESS.............." + response.body().getMessage());
                    // Borra la solicitud de la cola solo si la subida fue exitosa
                    ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                    SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud(); // Obtén la primera solicitud
                    if (solicitud != null) {
                        colaSolicitudes.obtenerIndexSolicitudyBorrar(); // Elimina la solicitud de la cola
                        isProcessing = false;  // Marcar como no procesando
                        procesarColaSolicitudes();
                        Log.d("SQLite", "Solicitud eliminada de la cola tras subida exitosa");
                    }
                } else {
                    Log.d("ErrorResponse", "Error en la subida: " + response.message());
                    isProcessing = false;  // Marcar como no procesando
                    procesarColaSolicitudes();
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                isProcessing = false;  // Marcar como no procesando
                procesarColaSolicitudes();
                // Aquí puedes optar por guardar el estado de la subida fallida
            }
        });
    }

}